import { Dimensions } from "react-native";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
const { height } = Dimensions.get("screen");

export const OnboardDP = () => {
    let illustration3Icon = {
        height: "",
        width: "",
    };
    let illustration2Icon = {
        height: "",
        width: "",
    };
    let titleFontSize = dpr(28);
    let textFontSize = dpr(18);
    let textBottom = dpr(20);
    let titleContainerBottom = dpr(80);
    if (height < 600) {
        illustration3Icon.height = dpr(250);
        illustration3Icon.width = dpr(260);
        illustration2Icon.height = dpr(300);
        titleFontSize = dpr(22);
        textFontSize = dpr(16);
    } else if (height > 600 && height < 700) {
        illustration3Icon.height = dpr(230);
        illustration3Icon.width = dpr(280);
        illustration2Icon.height = dpr(280);
        titleFontSize = dpr(26);
        textFontSize = dpr(18);
    } else if (height > 700 && height < 800) {
        illustration3Icon.height = dpr(300);
        illustration3Icon.width = dpr(350);
        illustration2Icon.height = dpr(350);
        titleFontSize = dpr(26);
        textFontSize = dpr(18);
    } else {
        illustration3Icon.height = dpr(320);
        illustration3Icon.width = dpr(360);
        illustration2Icon.height = dpr(400);
        titleFontSize = dpr(32);
        textFontSize = dpr(20);
        titleContainerBottom = dpr(90);
    }
    return {
        illustration3Icon,
        illustration2Icon,
        titleFontSize,
        textFontSize,
        textBottom,
        titleContainerBottom,
    };
};
